/**
* \file: DummyMediaPlaybackStatusImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: D. Girnus / ADIT/SW2 / dgirnus@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_DUMMYMEDIAPLAYBACKSTATUSIMPL_H_
#define AAUTO_DUMMYMEDIAPLAYBACKSTATUSIMPL_H_


#include <string>
#include <aauto/MediaPlaybackStatusEndpoint.h>
#include <aauto/GalReceiver.h>

#include <aauto/AditMediaPlaybackStatus.h>
#include <uspi/ConfigHandle.h>


namespace adit { namespace aauto {

class DummyMediaPlaybackStatusImpl : public IMediaPlaybackStatusCallbacks
{
public:
    DummyMediaPlaybackStatusImpl(MediaPlaybackStatusEndpoint* inEndpoint,
            void* inSessionContext);

    ~DummyMediaPlaybackStatusImpl();

    // implementation of DummyMediaPlaybackStatus methods
    void setConfigItem(std::string inKey, std::string inValue);
    void registerCallbacks(IAditMediaPlaybackStatusCallbacks* inCallbacks);
    bool init();
    void shutdown();

protected:
    // inherit IMediaPlaybackStatusCallbacks
    int mediaPlaybackStatusCallback(struct MediaPlaybackStatusStruct inStatus);
    int mediaPlaybackMetadataCallback(
            struct MediaPlaybackMetadataStruct inMetadata);

private:
    void* mSessionContext;
    MediaPlaybackStatusEndpoint* mEndpoint;
    IAditMediaPlaybackStatusCallbacks* mCallbacks;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_DUMMYMEDIAPLAYBACKSTATUSIMPL_H_ */
